/*
 * CaloAxisChi2VsRigHistoAction.h
 *
 *  Created on: 2010-02-22
 *      Author: S. Ricciarini
 */

/*! @file CaloAxisChi2VsRigHistoAction.h The CaloAxisChi2VsRigHistoAction class declaration file. */

#ifndef CALOAXISCHI2VSRIGHISTOACTION_H_
#define CALOAXISCHI2VSRIGHISTOACTION_H_

#include "../Histo2DAction/Histo2DAction.h"
#include "../../../CaloAxis2.h"

/*! @brief An action that fills a (X or Y) CaloAxis Chi2 Vs. Trk Rig histogram. */
class CaloAxisChi2VsRigHistoAction: public Histo2DAction<Int_t> {

public:

  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param axis The CaloAxis object.
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   *             in ROOT's reference guide).
   * @param outRoot If true, an output ROOT file named outFileBase + ".root" will be produced.
   * @param outText If true, an output text file named outFileBase + ".txt" will be produced. It will overwrite an
   *                eventually existing file with the same name.
   * @param title The ROOT histogram title.
   */
  CaloAxisChi2VsRigHistoAction(const char *actionName, CaloAxis *axis, TString outFileBase = "",
      TString mode = "UPDATE", bool outRoot = true, bool outText = true, TString title = "CALO axis chi2 vs TRK rig");

  /*! @brief Destructor */
  ~CaloAxisChi2VsRigHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

private:

  CaloAxis *_axis;

};
#endif /* CALOAXISCHI2VSRIGHISTOACTION_H_ */
